unit Form_songLibrary;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BusinessSkinForm, bsSkinCtrls, ExtCtrls, MMObj, MMBmpLst,
  MMBmpBtn, MMPanel, MMFill, Grids, BaseGrid, AdvGrid, AdvCGrid, StdCtrls,
  bsSkinBoxCtrls, bsfilectrl, abfControls,MMMPEG, ComCtrls, MMDSPObj,
  MMWavOut, MMPitch, MMAudio, AdvSmoothButton, DB, mySQLDbTables;

type
  TMusicLibrary = class(TForm)
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    bsSkinPanel2: TbsSkinPanel;
    bsSkinPanel1: TbsSkinPanel;
    bsSkinPanel4: TbsSkinPanel;
    MMPanelFill3: TMMPanelFill;
    AdvColumnGrid1: TAdvColumnGrid;
    bsSkinPanel5: TbsSkinPanel;
    MMPanelFill4: TMMPanelFill;
    MMPanelFill5: TMMPanelFill;
    addplaylist: TMMBitmapButton;
    MMPanelFill2: TMMPanelFill;
    Bevel1: TBevel;
    bsSkinPanel3: TbsSkinPanel;
    MMPanelFill7: TMMPanelFill;
    title: TLabel;
    MMPanelFill6: TMMPanelFill;
    MMPanelFill8: TMMPanelFill;
    Panel_FileExplore: TbsSkinPanel;
    MainPanel: TbsSkinPanel;
    filelistbox: TbsSkinFileListBox;
    playlistgrid: TAdvColumnGrid;
    MMPanelFill1: TMMPanelFill;
    MMPanelFill11: TMMPanelFill;
    MMBitmapButton1: TMMBitmapButton;
    MMBitmapButton40: TMMBitmapButton;
    MMBitmapButton41: TMMBitmapButton;
    MMBitmapButton43: TMMBitmapButton;
    MMBitmapButton44: TMMBitmapButton;
    MMBitmapButton45: TMMBitmapButton;
    MMBitmapButton46: TMMBitmapButton;
    MMBitmapButton47: TMMBitmapButton;
    MMBitmapButton48: TMMBitmapButton;
    MMBitmapButton49: TMMBitmapButton;
    MMBitmapButton50: TMMBitmapButton;
    MMBitmapButton51: TMMBitmapButton;
    MMBitmapButton52: TMMBitmapButton;
    MMBitmapButton53: TMMBitmapButton;
    MMBitmapButton54: TMMBitmapButton;
    MMBitmapButton55: TMMBitmapButton;
    MMBitmapButton56: TMMBitmapButton;
    MMBitmapButton57: TMMBitmapButton;
    MMBitmapButton75: TMMBitmapButton;
    MMBitmapButton74: TMMBitmapButton;
    MMBitmapButton73: TMMBitmapButton;
    MMBitmapButton72: TMMBitmapButton;
    MMBitmapButton71: TMMBitmapButton;
    MMBitmapButton70: TMMBitmapButton;
    MMBitmapButton69: TMMBitmapButton;
    MMBitmapButton68: TMMBitmapButton;
    MMBitmapButton67: TMMBitmapButton;
    MMBitmapButton66: TMMBitmapButton;
    MMBitmapButton65: TMMBitmapButton;
    MMBitmapButton64: TMMBitmapButton;
    MMBitmapButton63: TMMBitmapButton;
    MMBitmapButton62: TMMBitmapButton;
    MMBitmapButton61: TMMBitmapButton;
    MMBitmapButton60: TMMBitmapButton;
    MMBitmapButton59: TMMBitmapButton;
    MMBitmapButton58: TMMBitmapButton;
    searchgrid: TAdvColumnGrid;
    bsSkinPanel6: TbsSkinPanel;
    bsSkinButton1: TbsSkinButton;
    bsSkinButton2: TbsSkinButton;
    bsSkinButton3: TbsSkinButton;
    bsSkinButton4: TbsSkinButton;
    bsSkinButton5: TbsSkinButton;
    bsSkinButton7: TbsSkinButton;
    bsSkinButton8: TbsSkinButton;
    FileExplorer: TbsSkinPanel;
    bsSkinDirectoryListBox1: TbsSkinDirectoryListBox;
    bsSkinDriveComboBox1: TbsSkinDriveComboBox;
    MMPanelFill10: TMMPanelFill;
    Label2: TLabel;
    MusicExplorer: TbsSkinPanel;
    MMPanelFill9: TMMPanelFill;
    Label1: TLabel;
    MusicLibTree: TbsSkinTreeView;
    bsSkinScrollBar1: TbsSkinScrollBar;
    Memo1: TMemo;
    progress: TbsSkinGauge;
    MMBitmapButton3: TMMBitmapButton;
    MMPanelFill12: TMMPanelFill;
    MMPanelFill13: TMMPanelFill;
    edTitle: TabfEdit;
    MMPanelFill14: TMMPanelFill;
    StaticText13: TStaticText;
    MMBitmapButton2: TMMBitmapButton;
    Searchindex: TbsSkinComboBox;
    MMPanelFill15: TMMPanelFill;
    Label3: TLabel;
    MMPanelFill16: TMMPanelFill;
    btn_play: TMMBitmapButton;
    btn_stop: TMMBitmapButton;
    audiofile: TMMAudioFile;
    pitch: TMMPitch;
    waveout: TMMWaveOut;
    newsinsert: TMMBitmapButton;
    CheckBox1: TCheckBox;
    chk1: TCheckBox;
    bsSkinButton6: TbsSkinButton;
    MMPanelFill17: TMMPanelFill;
    btn_temp: TAdvSmoothButton;
    PanelMusicLib: TMMPanelFill;
    TempPlaylist: TMMPanelFill;
    bsSkinPanel7: TbsSkinPanel;
    tempgrid: TAdvColumnGrid;
    bsSkinPanel8: TbsSkinPanel;
    MMPanelFill19: TMMPanelFill;
    MMPanelFill22: TMMPanelFill;
    MMBitmapButton4: TMMBitmapButton;
    MMPanelFill23: TMMPanelFill;
    MMPanelFill20: TMMPanelFill;
    MMBitmapButton5: TMMBitmapButton;
    MMBitmapButton6: TMMBitmapButton;
    MMBitmapButton7: TMMBitmapButton;
    MMBitmapButton8: TMMBitmapButton;
    MMBitmapButton9: TMMBitmapButton;
    MMBitmapButton10: TMMBitmapButton;
    MMBitmapButton11: TMMBitmapButton;
    MMPanelFill18: TMMPanelFill;
    MMBitmapButton12: TMMBitmapButton;
    MMBitmapButton13: TMMBitmapButton;
    MMBitmapButton14: TMMBitmapButton;
    txt1: TStaticText;
    bsSkinScrollBar6: TbsSkinScrollBar;
    treeGrid: TAdvColumnGrid;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bsSkinDirectoryListBox2Change(Sender: TObject);
    procedure bsSkinButton1Click(Sender: TObject);
    procedure playlistgridClick(Sender: TObject);
    procedure addplaylistClick(Sender: TObject);
    procedure MMBitmapButton2Click(Sender: TObject);
    procedure MMBitmapButton1Click(Sender: TObject);
    procedure MMBitmapButton40Click(Sender: TObject);
    procedure MMBitmapButton41Click(Sender: TObject);
    procedure MMBitmapButton43Click(Sender: TObject);
    procedure MMBitmapButton44Click(Sender: TObject);
    procedure MMBitmapButton45Click(Sender: TObject);
    procedure MMBitmapButton46Click(Sender: TObject);
    procedure MMBitmapButton47Click(Sender: TObject);
    procedure MMBitmapButton48Click(Sender: TObject);
    procedure MMBitmapButton49Click(Sender: TObject);
    procedure MMBitmapButton50Click(Sender: TObject);
    procedure MMBitmapButton51Click(Sender: TObject);
    procedure MMBitmapButton52Click(Sender: TObject);
    procedure MMBitmapButton53Click(Sender: TObject);
    procedure MMBitmapButton54Click(Sender: TObject);
    procedure MMBitmapButton55Click(Sender: TObject);
    procedure MMBitmapButton56Click(Sender: TObject);
    procedure MMBitmapButton57Click(Sender: TObject);
    procedure MMBitmapButton58Click(Sender: TObject);
    procedure MMBitmapButton59Click(Sender: TObject);
    procedure MMBitmapButton60Click(Sender: TObject);
    procedure MMBitmapButton61Click(Sender: TObject);
    procedure MMBitmapButton62Click(Sender: TObject);
    procedure MMBitmapButton63Click(Sender: TObject);
    procedure MMBitmapButton64Click(Sender: TObject);
    procedure MMBitmapButton65Click(Sender: TObject);
    procedure MMBitmapButton66Click(Sender: TObject);
    procedure MMBitmapButton67Click(Sender: TObject);
    procedure MMBitmapButton68Click(Sender: TObject);
    procedure MMBitmapButton69Click(Sender: TObject);
    procedure MMBitmapButton70Click(Sender: TObject);
    procedure MMBitmapButton71Click(Sender: TObject);
    procedure MMBitmapButton72Click(Sender: TObject);
    procedure MMBitmapButton73Click(Sender: TObject);
    procedure MMBitmapButton74Click(Sender: TObject);
    procedure MMBitmapButton75Click(Sender: TObject);
    procedure bsSkinButton6Click(Sender: TObject);
    procedure bsSkinButton2Click(Sender: TObject);
    procedure filelistboxClick(Sender: TObject);
    procedure MMBitmapButton3Click(Sender: TObject);
    procedure bsSkinButton3Click(Sender: TObject);
    procedure bsSkinButton4Click(Sender: TObject);
    procedure bsSkinButton5Click(Sender: TObject);
    procedure bsSkinButton7Click(Sender: TObject);
    procedure bsSkinButton8Click(Sender: TObject);
    procedure btn_playClick(Sender: TObject);
    procedure btn_stopClick(Sender: TObject);
    procedure searchgridClick(Sender: TObject);
    procedure newsinsertClick(Sender: TObject);
    procedure MusicLibTreeClick(Sender: TObject);
    procedure MusicLibTreeChange(Sender: TObject; Node: TTreeNode);
    procedure btn_tempClick(Sender: TObject);
    procedure MMBitmapButton9Click(Sender: TObject);
    procedure MMBitmapButton8Click(Sender: TObject);
    procedure MMBitmapButton5Click(Sender: TObject);
    procedure MMBitmapButton4Click(Sender: TObject);
    procedure MMBitmapButton11Click(Sender: TObject);
    procedure MMBitmapButton6Click(Sender: TObject);
    procedure MMBitmapButton7Click(Sender: TObject);
    procedure MMBitmapButton10Click(Sender: TObject);
    procedure tempgridClick(Sender: TObject);
    procedure MMBitmapButton14Click(Sender: TObject);
    procedure MMBitmapButton12Click(Sender: TObject);
    procedure MMBitmapButton13Click(Sender: TObject);
  private
    { Private declarations }
    Procedure load_treelibs(namegrid:string);
  public
    { Public declarations }
  end;

var
  MusicLibrary: TMusicLibrary;
  reload:boolean;

implementation

uses form_mainform, Form_playlist, ID2, Form_tester, Form_LibraryEditor,
  Form_newscompose, form_progress;

{$R *.dfm}

procedure TMusicLibrary.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  repeat
    MusicLibrary.FormStyle:=fsnormal;
  until MusicLibrary.FormStyle=fsnormal;
  Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure TMusicLibrary.bsSkinDirectoryListBox2Change(Sender: TObject);
var i:Integer;
    types:string;
begin
  playlistgrid.ClearRows(1,playlistgrid.RowCount);
  playlistgrid.RowCount:=2;

  musiclibrary.searchgrid.ClearRows(1,playlistgrid.RowCount);
  musiclibrary.searchgrid.RowCount:=2;

  filelistbox.Update;
  searchgrid.Visible:=false;

  if directoryexists(bsSkinDirectoryListBox1.Directory)=true then
  begin
    filelistbox.Directory:=bsSkinDirectoryListBox1.Directory;
    filelistbox.Update;
    //Add database;
    progress.MaxValue:=filelistbox.Items.Count-1;
    progress.Value:=0;

    for i:=0 to filelistbox.Items.Count-1 do
    begin
      progress.Value:=i;

      filelistbox.ItemIndex:=i;

      if chk1.Checked then
      begin
        if IsMpegFile(filelistbox.FileName) then
        begin
          formid3.Edit1.Text:=filelistbox.FileName;
          formid3.Button1.OnClick(self);
        end;
      end;

      if playlistgrid.Cells[0,1]<>'' then playlistgrid.RowCount:=Playlistgrid.RowCount+1;

      playlistgrid.Cells[0,playlistgrid.RowCount-1]:=filelistbox.Items.Strings[i];
      if chk1.Checked then
      begin
        playlistgrid.Cells[1,playlistgrid.RowCount-1]:=formid3.ArtistEdit.Text;
        playlistgrid.Cells[2,playlistgrid.RowCount-1]:=formid3.AlbumEdit.Text;
        playlistgrid.Cells[3,playlistgrid.RowCount-1]:=formid3.GenreEdit.Text;
        playlistgrid.Cells[4,playlistgrid.RowCount-1]:=formid3.YearEdit.Text;
      end else
      begin
        playlistgrid.Cells[1,playlistgrid.RowCount-1]:='-';
        playlistgrid.Cells[2,playlistgrid.RowCount-1]:='-';
        playlistgrid.Cells[3,playlistgrid.RowCount-1]:='-';
        playlistgrid.Cells[4,playlistgrid.RowCount-1]:='-';
      end;
      playlistgrid.Cells[5,playlistgrid.RowCount-1]:=filelistbox.FileName;
    end;
    //
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Directory doesnt exists!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Directory tidak diketemukan!',mtconfirmation,[mbok],0);
  end;
  progress.MaxValue:=1;
  progress.Value:=0;
end;

procedure TMusicLibrary.bsSkinButton1Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;

  reload:=false;
  treegrid.RowCount:=2;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  playlistgrid.RowCount:=2;
  for i:=0 to playlistgrid.ColCount-1 do playlistgrid.Cells[i,1]:='';
  label1.caption:='FILE EXPLORER';

  fileexplorer.Visible:=true;
  MusicExplorer.Visible:=false;

  progress.Value:=0;
end;

procedure TMusicLibrary.playlistgridClick(Sender: TObject);
begin
  if playlistgrid.Cells[0,playlistgrid.row]<>'' then
  begin
     title.Caption:=playlistgrid.Cells[0,playlistgrid.row];
     mainform.testertitle.Caption:=title.Caption;
     formtester.FName1.Caption:=playlistgrid.Cells[5,playlistgrid.row];
  end else
  begin
     title.Caption:='';
     mainform.testertitle.Caption:='';
     formtester.FName1.Caption:=''
  end;
end;

procedure TMusicLibrary.addplaylistClick(Sender: TObject);
var insertindex:Integer;
begin
    if searchgrid.Visible=false then
    begin
      if fileexists(MusicLibrary.playlistgrid.Cells[5,MusicLibrary.playlistgrid.Row]) then
      begin
      if MusicLibrary.playlistgrid.Cells[5,MusicLibrary.playlistgrid.Row]<>'' then
         with playlist do
         begin
          if playlistgrid.Cells[1,1]<>'' then playlistgrid.InsertRows(playlistgrid.row+1,1);
          if Playlistgrid.Cells[1,1]=''  then insertindex:=1 else insertindex:=playlistgrid.row+1;

             playlistgrid.cells[1,insertindex]:=extractfilename(MusicLibrary.playlistgrid.Cells[5,MusicLibrary.playlistgrid.Row]);
             playlistgrid.Cells[5,insertindex]:=MusicLibrary.playlistgrid.Cells[5,MusicLibrary.playlistgrid.Row];
             playlistgrid.Cells[0,insertindex]:='WAITING';


          if label1.Caption='FILE EXPLORER'   then playlistgrid.Cells[6,insertindex]:='OTHER';
          if label1.Caption='MUSIC LIBRARY'   then playlistgrid.Cells[6,insertindex]:='MUSIC';
          if label1.Caption='INSERT LIBRARY'  then playlistgrid.Cells[6,insertindex]:='INSERT';
          if label1.Caption='JINGLES LIBRARY' then playlistgrid.Cells[6,insertindex]:='JINGLE';
          if label1.Caption='COMM LIBRARY'    then playlistgrid.Cells[6,insertindex]:='COMMERCIAL';
          if label1.Caption='ADLIBS LIBRARY'  then playlistgrid.Cells[6,insertindex]:='ADLIB';
          if label1.Caption='OTHERS LIBRARY'  then playlistgrid.Cells[6,insertindex]:='OTHER';

          if musicLibrary.playlistgrid.Cells[6,MusicLibrary.playlistgrid.Row]<>'' then
          begin
            Playlistgrid.Cells[3,insertindex]:=MusicLibrary.playlistgrid.Cells[6,MusicLibrary.playlistgrid.Row];
            Playlistgrid.Cells[2,insertindex]:=MSecToTime(StrToInt(MusicLibrary.playlistgrid.Cells[6,MusicLibrary.playlistgrid.Row]))
          end else
          begin
            mpegfile.FileName:=MusicLibrary.playlistgrid.Cells[5,MusicLibrary.playlistgrid.Row];
            Playlistgrid.Cells[3,insertindex]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
            Playlistgrid.Cells[2,insertindex]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);
            mpegfile.FreeMpeg;
          end;

          {
          mpegfile.FileName:=MusicLibrary.playlistgrid.Cells[5,MusicLibrary.playlistgrid.Row];
          playlistgrid.Cells[3,insertindex]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
          playlistgrid.Cells[2,insertindex]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);
          mpegfile.FreeMpeg;
          }
          cek_total;

          playlistindex:=mainform.getindex;
          mainform.settimeup(playlistindex);
          mainform.playlist_color;

          playlist.playlistgrid.AutoSizeRows(false,0);
          playlist.Playlistgrid.SaveTofile(savedir+'setting\playlist.dat');
          playlistgrid.row:=insertindex;
         end;
      end else
      begin
          if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
          if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
      end;
    end else  //searchgrid=true then
    if searchgrid.Visible=true then
    begin
        if fileexists(MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row]) then
        begin
        if MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row]<>'' then
        with playlist do
        begin
          if playlistgrid.Cells[1,1]<>'' then playlistgrid.InsertRows(playlistgrid.row+1,1);
          if Playlistgrid.Cells[1,1]=''  then insertindex:=1 else insertindex:=playlistgrid.row+1;

          //ShowMessage(IntToStr(insertindex)+' '+inttostr(MusicLibrary.searchgrid.Row));

          playlistgrid.cells[1,insertindex]:=extractfilename(MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row]);
          playlistgrid.Cells[5,insertindex]:=MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row];
          playlistgrid.Cells[0,insertindex]:='WAITING';

          if label1.Caption='FILE EXPLORER'   then playlistgrid.Cells[6,insertindex]:='OTHER';
          if label1.Caption='MUSIC LIBRARY'   then playlistgrid.Cells[6,insertindex]:='MUSIC';
          if label1.Caption='INSERT LIBRARY'  then playlistgrid.Cells[6,insertindex]:='INSERT';
          if label1.Caption='JINGLES LIBRARY' then playlistgrid.Cells[6,insertindex]:='JINGLE';
          if label1.Caption='COMM LIBRARY'    then playlistgrid.Cells[6,insertindex]:='COMMERCIAL';
          if label1.Caption='ADLIBS LIBRARY'  then playlistgrid.Cells[6,insertindex]:='ADLIB';
          if label1.Caption='OTHERS LIBRARY'  then playlistgrid.Cells[6,insertindex]:='OTHER';


          if MusicLibrary.searchgrid.Cells[6,MusicLibrary.searchgrid.Row]<>'' then
          begin
            Playlistgrid.Cells[3,insertindex]:=MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row];
            Playlistgrid.Cells[2,insertindex]:=MSecToTime(StrToInt(MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row]));
          end else
          begin
            mpegfile.FileName:=MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row];
            Playlistgrid.Cells[3,insertindex]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
            Playlistgrid.Cells[2,insertindex]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);
            mpegfile.FreeMpeg;
          end;

          //mpegfile.FileName:=MusicLibrary.searchgrid.Cells[5,MusicLibrary.searchgrid.Row];
          //playlistgrid.Cells[3,insertindex]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
          //playlistgrid.Cells[2,insertindex]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);

          //mpegfile.FreeMpeg;

          cek_total;

          playlistindex:=mainform.getindex;
          mainform.settimeup(playlistindex);
          mainform.playlist_color;

          playlist.playlistgrid.AutoSizeRows(false,0);
          playlist.Playlistgrid.SaveTofile(savedir+'setting\playlist.dat');
          playlistgrid.row:=insertindex;
        end;
      end else
      begin
          if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
          if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
      end;
    end;
end;

procedure TMusicLibrary.MMBitmapButton2Click(Sender: TObject);
var i,j:integer;
    types:string;
begin
  if label1.Caption='FILE EXPLORER'   then types:='OTHER';
  if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
  if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
  if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
  if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
  if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
  if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

  musiclibrary.searchgrid.Visible:=true;

  musiclibrary.searchgrid.ClearRows(1,playlistgrid.RowCount);
  musiclibrary.searchgrid.Visible:=true;
  musiclibrary.searchgrid.RowCount:=2;

  if CheckBox1.Checked=false then
  begin
    for i:=1 to playlistgrid.RowCount-1 do
    begin
      if pos(uppercase(edtitle.Text),uppercase(playlistgrid.Cells[searchindex.itemindex,i]))>0 then
      begin
          if musiclibrary.searchgrid.Cells[0,1]<>'' then musiclibrary.searchgrid.RowCount:=musiclibrary.searchgrid.RowCount+1;
          for j:=0 to musiclibrary.playlistgrid.ColCount-1 do
          musiclibrary.searchgrid.Cells[j,musiclibrary.searchgrid.RowCount-1]:=musiclibrary.playlistgrid.Cells[j,i];
      end;
    end;
  end else
  begin
      mainform.db_song.First;
      while not  mainform.db_song.Eof do
      begin
            if ((mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
               (mainform.db_song.FieldByName('Type').AsString  =types ) and
               (pos(uppercase(edtitle.Text),uppercase(mainform.db_song.FieldByName(Searchindex.Text).AsString))>0)) then
            begin
              if searchgrid.Cells[0,searchgrid.RowCount-1]<>'' then searchgrid.RowCount:=searchgrid.RowCount+1;
                 searchgrid.Cells[0,searchgrid.RowCount-1]:=mainform.db_song.FieldByName('Filename').AsString;
                 searchgrid.Cells[1,searchgrid.RowCount-1]:=mainform.db_song.FieldByName('Artist').AsString;
                 searchgrid.Cells[2,searchgrid.RowCount-1]:=mainform.db_song.FieldByName('Album').AsString;
                 searchgrid.Cells[3,searchgrid.RowCount-1]:=mainform.db_song.FieldByName('Genre').AsString;
                 searchgrid.Cells[4,searchgrid.RowCount-1]:=mainform.db_song.FieldByName('Year').AsString;
                 searchgrid.Cells[5,searchgrid.RowCount-1]:=mainform.db_song.FieldByName('Path').AsString;
            end;
            mainform.db_song.Next;
          end;
  end;

  musiclibrary.searchgrid.AutoSizeRows(false,0);
  for i:= 1 to musiclibrary.searchgrid.RowCount-1 do
  if i mod 2 =0 then musiclibrary.searchgrid.RowColor[i]:=$00E8E8E8 else musiclibrary.searchgrid.RowColor[i]:=clwhite;

  //musiclibrary.total.Caption:=inttostr(musiclibrary.searchgrid.RowCount-1)+' Songs';
end;

procedure search(index:string);
var i,j:integer;
begin
  musiclibrary.searchgrid.Visible:=true;
  musiclibrary.searchgrid.RowCount:=2;
  for i:=0 to musiclibrary.searchgrid.ColCount-1 do musiclibrary.searchgrid.Cells[i,1]:='';

  for i:=1 to musiclibrary.playlistgrid.RowCount-1 do
  begin
      if uppercase(copy(musiclibrary.playlistgrid.Cells[0,i],0,1))=uppercase(index) then
      begin
        if musiclibrary.searchgrid.Cells[0,1]<>'' then musiclibrary.searchgrid.RowCount:=musiclibrary.searchgrid.RowCount+1;
        for j:=0 to musiclibrary.playlistgrid.ColCount-1 do
        musiclibrary.searchgrid.Cells[j,musiclibrary.searchgrid.RowCount-1]:=musiclibrary.playlistgrid.Cells[j,i];
      end;
  end;
  musiclibrary.searchgrid.AutoSizeRows(false,0);
  for i:= 1 to musiclibrary.searchgrid.RowCount-1 do
  if i mod 2 =0 then musiclibrary.searchgrid.RowColor[i]:=$00E8E8E8 else musiclibrary.searchgrid.RowColor[i]:=clwhite;

  //musiclibrary.total.Caption:=inttostr(musiclibrary.searchgrid.RowCount-1)+' Songs';
end;


procedure TMusicLibrary.MMBitmapButton1Click(Sender: TObject);
begin
    search('A');
end;

procedure TMusicLibrary.MMBitmapButton40Click(Sender: TObject);
begin
  search('B');
end;

procedure TMusicLibrary.MMBitmapButton41Click(Sender: TObject);
begin
  search('C');
end;

procedure TMusicLibrary.MMBitmapButton43Click(Sender: TObject);
begin
  search('D');
end;

procedure TMusicLibrary.MMBitmapButton44Click(Sender: TObject);
begin
  search('E');
end;

procedure TMusicLibrary.MMBitmapButton45Click(Sender: TObject);
begin
  search('F');
end;

procedure TMusicLibrary.MMBitmapButton46Click(Sender: TObject);
begin
  search('G');
end;

procedure TMusicLibrary.MMBitmapButton47Click(Sender: TObject);
begin
  search('H');
end;

procedure TMusicLibrary.MMBitmapButton48Click(Sender: TObject);
begin
search('I');
end;

procedure TMusicLibrary.MMBitmapButton49Click(Sender: TObject);
begin
  search('J');
end;

procedure TMusicLibrary.MMBitmapButton50Click(Sender: TObject);
begin
search('K');
end;

procedure TMusicLibrary.MMBitmapButton51Click(Sender: TObject);
begin
search('L');
end;

procedure TMusicLibrary.MMBitmapButton52Click(Sender: TObject);
begin
search('M');
end;

procedure TMusicLibrary.MMBitmapButton53Click(Sender: TObject);
begin
search('N');
end;

procedure TMusicLibrary.MMBitmapButton54Click(Sender: TObject);
begin
search('O');
end;

procedure TMusicLibrary.MMBitmapButton55Click(Sender: TObject);
begin
search('P');
end;

procedure TMusicLibrary.MMBitmapButton56Click(Sender: TObject);
begin
search('Q');
end;

procedure TMusicLibrary.MMBitmapButton57Click(Sender: TObject);
begin
  search('R');
end;

procedure TMusicLibrary.MMBitmapButton58Click(Sender: TObject);
begin
  search('S');
end;

procedure TMusicLibrary.MMBitmapButton59Click(Sender: TObject);
begin
search('T');
end;

procedure TMusicLibrary.MMBitmapButton60Click(Sender: TObject);
begin
  search('U');
end;

procedure TMusicLibrary.MMBitmapButton61Click(Sender: TObject);
begin
  search('V');
end;

procedure TMusicLibrary.MMBitmapButton62Click(Sender: TObject);
begin
search('W');
end;

procedure TMusicLibrary.MMBitmapButton63Click(Sender: TObject);
begin
  search('X');
end;

procedure TMusicLibrary.MMBitmapButton64Click(Sender: TObject);
begin
search('Y');
end;

procedure TMusicLibrary.MMBitmapButton65Click(Sender: TObject);
begin
search('Z');
end;

procedure TMusicLibrary.MMBitmapButton66Click(Sender: TObject);
begin
  search('0');
end;

procedure TMusicLibrary.MMBitmapButton67Click(Sender: TObject);
begin
  search('1');
end;

procedure TMusicLibrary.MMBitmapButton68Click(Sender: TObject);
begin
  search('2');
end;

procedure TMusicLibrary.MMBitmapButton69Click(Sender: TObject);
begin
  search('3');
end;

procedure TMusicLibrary.MMBitmapButton70Click(Sender: TObject);
begin
  search('4');
end;

procedure TMusicLibrary.MMBitmapButton71Click(Sender: TObject);
begin
  search('5');
end;

procedure TMusicLibrary.MMBitmapButton72Click(Sender: TObject);
begin
  search('6');
end;

procedure TMusicLibrary.MMBitmapButton73Click(Sender: TObject);
begin
search('7');
end;

procedure TMusicLibrary.MMBitmapButton74Click(Sender: TObject);
begin
search('8');
end;

procedure TMusicLibrary.MMBitmapButton75Click(Sender: TObject);
begin
  search('9');
end;

procedure drawtree(filename:string);
var i,j:integer;
    space:string;
begin

  with MusicLibrary do
  begin
   musiclibtree.ChangeDelay:=100;
   musiclibtree.Items.Clear;
   MusicLibTree.Update;
   memo1.Lines.Clear;

   if treeGrid.RowCount<2 then treeGrid.RowCount:=2;

   if treeGrid.Cells[0,1]<>'' then
   for i:=1 to treegrid.RowCount-1 do
   begin
      if treegrid.Cells[2,i]<>'' then
      begin
        space:='';
        if strtoint(treegrid.Cells[2,i])>1 then
        begin
          for j:=1 to strtoint(treegrid.Cells[2,i])-1 do
          begin
            space:=space+' ';
          end;
        end;
        memo1.Lines.Add(space+treegrid.Cells[0,i]);
      end;
   end else Memo1.Lines.Clear;

   memo1.Lines.SaveToFile(savedir+'temp');
   MusicLibTree.LoadFromFile(savedir+'temp');

   MusicLibTree.FullExpand;
   MusicLibTree.Update;
   MusicLibTree.Refresh;

  end;
  musiclibrary.progress.Value:=0;
end;

Procedure TMusicLibrary.load_treelibs(namegrid:string);
var databases : Tmysqltable;
    i:integer;
begin
   if namegrid='musiclib.dat'       then databases:=mainform.db_treemusic;
   if namegrid='newslib.dat'        then databases:=mainform.tree_news;
   if namegrid='otherslib.dat'      then databases:=mainform.tree_other;
   if namegrid='adlibslib.dat'      then databases:=mainform.tree_adlib;
   if namegrid='commercialslib.dat' then databases:=mainform.tree_commercial;
   if namegrid='jingleslib.dat'     then databases:=mainform.tree_jingle;
   if namegrid='Insertlib.dat'      then databases:=mainform.tree_insert;

   treegrid.ClearRows(1,treegrid.RowCount);
   treegrid.RowCount:=2;

   databases.First;
   while not databases.Eof do
   begin
    if UpperCase(databases.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
    begin
      if  treegrid.cells[0,1]<>'' then  treegrid.rowcount:= treegrid.rowcount+1;
          treegrid.cells[0,treegrid.rowcount-1]:=databases.FieldByName('List').AsString;
          treegrid.cells[1,treegrid.rowcount-1]:=databases.FieldByName('Path').AsString;
          treegrid.cells[2,treegrid.rowcount-1]:=databases.FieldByName('Indeks').AsString;

    end;
    databases.Next;
   end;

   {
   databases.EmptyTable;
   for i:=1 to treeGrid.RowCount-1 do
   begin
      databases.Append;
      databases.FieldByName('List').AsString  :=treeGrid.Cells[0,i];
      databases.FieldByName('Path').AsString  :=treeGrid.Cells[1,i];
      databases.FieldByName('Indeks').AsString:=treeGrid.Cells[2,i];
      databases.Post;
   end;
   }

       {
       MusicLibrary.MusicLibTree.Items.Clear;
       MusicLibrary.MusicLibTree.Update;
       MusicLibrary.MusicLibTree.Refresh;


       MusicLibrary.Memo1.Lines.Clear;

       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.First;
          while not mainform.tree_news.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.tree_news.FieldByName('List').AsString);
            mainform.tree_news.Next;
          end;
       end;

       if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.First;
          while not mainform.tree_other.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.tree_other.FieldByName('List').AsString);
            mainform.tree_other.Next;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.First;
          while not mainform.tree_adlib.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.tree_adlib.FieldByName('List').AsString);
            mainform.tree_adlib.Next;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.First;
          while not mainform.tree_commercial.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.tree_commercial.FieldByName('List').AsString);
            mainform.tree_commercial.Next;
          end;
       end;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.First;
          while not mainform.db_treemusic.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.db_treemusic.FieldByName('List').AsString);
            mainform.db_treemusic.Next;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.First;
          while not mainform.tree_jingle.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.tree_jingle.FieldByName('List').AsString);
            mainform.tree_jingle.Next;
          end;
       end;

       if namegrid='Insertlib.dat' then
       begin
          //ShowMessage('tes');
          mainform.tree_insert.First;
          while not mainform.tree_insert.Eof do
          begin
            MusicLibrary.Memo1.Lines.Add(mainform.tree_insert.FieldByName('List').AsString);
            mainform.tree_insert.Next;
          end;
       end;

    MusicLibrary.Memo1.Lines.SaveToFile(workdir+'Share\'+namegrid);
    MusicLibrary.treeGrid.LoadFromFile(workdir+'Share\'+namegrid);
    }
    if MusicLibrary.treeGrid.RowCount<2 then MusicLibrary.treeGrid.RowCount:=2;
end;

procedure TMusicLibrary.bsSkinButton6Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;
  
  reload:=false;
  progress.Value:=0;
  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='NEWS LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;

  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  mainform.clear_grid(Treegrid);

  load_treelibs('newslib.dat');
  filelistbox.Update;

  drawtree('newslib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.bsSkinButton2Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;

  reload:=false;
  progress.Value:=0;

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='MUSIC LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;

  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  mainform.clear_grid(Treegrid);

  load_treelibs('musiclib.dat');
  filelistbox.Update;

  drawtree('musiclib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.filelistboxClick(Sender: TObject);
var i:integer;
    filename:int64;
    ketemu:boolean;
    namegrid:string;
begin
end;

procedure TMusicLibrary.MMBitmapButton3Click(Sender: TObject);
var i:Integer;
    types:string;
begin
  if RBO_ID<>'' then
  begin
  if label1.Caption='FILE EXPLORER'   then types:='OTHER';
  if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
  if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
  if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
  if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
  if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
  if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
  if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

  if directoryexists(treegrid.Cells[1,treegrid.row])=true then
  begin
    mainform.Enabled:=false;
    reloadform.Visible:=True;
    Sleep(1000);

    filelistbox.Directory:=treegrid.Cells[1,treegrid.row];
    filelistbox.Update;
    //Add database;
    progress.MaxValue:=filelistbox.Items.Count;
    reloadform.AdvProgress1.Max:=progress.MaxValue;
    progress.Value:=0;

    mainform.db_song.First;
    while not  mainform.db_song.Eof do
    begin
      if ((mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
          (mainform.db_song.FieldByName('Type').AsString  =types ) and
          (mainform.db_song.FieldByName('Kategori').AsString=treegrid.Cells[0,treegrid.row])) then
          begin
             mainform.db_song.Delete;
          end else mainform.db_song.Next;
    end;
    mainform.db_song.Refresh;

    if filelistbox.Items.Count>0 then
    for i:=0 to filelistbox.Items.Count-1 do
    begin
      progress.Value:=i;
      filelistbox.ItemIndex:=i;
      reloadform.AdvProgress1.Position:=i;

      if chk1.Checked=true then
      begin
        if IsMpegFile(filelistbox.FileName) then
        begin
          formid3.Edit1.Text:=filelistbox.FileName;
          formid3.Button1.OnClick(self);
        end;
      end;

      mainform.db_song.Append;

      mainform.db_song.FieldByName('RBO_ID').AsString  :=RBO_ID;
      mainform.db_song.FieldByName('Type').AsString    :=types;
      mainform.db_song.FieldByName('Kategori').AsString:=treegrid.Cells[0,treegrid.row];
      mainform.db_song.FieldByName('Filename').AsString:=filelistbox.Items.Strings[i];

      if chk1.Checked=true then
      begin
        mainform.db_song.FieldByName('Artist').AsString  :=formid3.ArtistEdit.Text;
        mainform.db_song.FieldByName('Album').AsString   :=formid3.AlbumEdit.Text;
        mainform.db_song.FieldByName('Genre').AsString   :=formid3.GenreEdit.Text;
        mainform.db_song.FieldByName('Year').AsString    :=formid3.YearEdit.Text;
      end else
      begin
        mainform.db_song.FieldByName('Artist').AsString  :='-';
        mainform.db_song.FieldByName('Album').AsString   :='-';
        mainform.db_song.FieldByName('Genre').AsString   :='-';
        mainform.db_song.FieldByName('Year').AsString    :='-';
      end;

      mainform.db_song.FieldByName('Path').AsString    :=filelistbox.FileName;
      mainform.db_song.FieldByName('Rate').AsString    :='0';
      mainform.db_song.Post;

    end;
  
    progress.Value:=0;
    //
    mainform.Enabled:=true;
    reloadform.Visible:=false;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Directory doesnt exists!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Directory tidak diketemukan!',mtconfirmation,[mbok],0);
  end;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Please Set RBO ID from setting menu!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Harap masukkan RBO ID dari menu pengaturan!',mtconfirmation,[mbok],0);
  end;
end;

procedure TMusicLibrary.bsSkinButton3Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;

  reload:=false;
  progress.Value:=0;

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='INSERT LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;

  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  mainform.clear_grid(Treegrid);

  load_treelibs('Insertlib.dat');
  filelistbox.Update;

  drawtree('Insertlib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.bsSkinButton4Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;
  
  reload:=false;
  progress.Value:=0;
  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='JINGLES LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;

  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  mainform.clear_grid(Treegrid);

  load_treelibs('jingleslib.dat');
  filelistbox.Update;

  drawtree('jingleslib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.bsSkinButton5Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;
  
  reload:=false;
  progress.Value:=0;
  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='COMM LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;
  
  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  mainform.clear_grid(Treegrid);

  load_treelibs('commercialslib.dat');
  filelistbox.Update;

  drawtree('commercialslib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.bsSkinButton7Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;
  
  reload:=false;
  progress.Value:=0;
  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='ADLIBS LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;

  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  mainform.clear_grid(Treegrid);

  load_treelibs('adlibslib.dat');
  filelistbox.Update;

  drawtree('adlibslib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.bsSkinButton8Click(Sender: TObject);
var i:integer;
begin
  TempPlaylist.Caption:='Show Temp Playlist';
  TempPlaylist.Visible:=False;
  
  reload:=false;
  progress.Value:=0;
  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  searchgrid.Visible:=false;
  label1.caption:='OTHERS LIBRARY';

  playlistgrid.ClearRows(1,playlistgrid.RowCount-2);
  playlistgrid.RowCount:=2;

  MusicExplorer.Visible:=true;
  fileexplorer.Visible:=false;

  load_treelibs('otherslib.dat');
  filelistbox.Update;

  drawtree('otherslib.dat');
  progress.Value:=0;
end;

procedure TMusicLibrary.btn_playClick(Sender: TObject);
begin
  if searchgrid.Visible=true then
  begin
    if fileexists(searchgrid.Cells[5,searchgrid.row]) then
    begin
      //if mainform.Label_onair.Caption='ON AIR' then mainform.btn_pause.OnClick(self);
      if IsMpegFile(searchgrid.Cells[5,searchgrid.row]) then
      begin
        audiofile.FileName :=searchgrid.Cells[5,searchgrid.row];
        audiofile.FadeOutDuration:=1000;
        audiofile.FadeInDuration:=500;
        WaveOut.Input := audiofile;
        waveout.Stop;
        waveout.Started;
      end;
    end else
    begin
      if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
      if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
    end;
  end else
  begin
    if fileexists(playlistgrid.Cells[5,playlistgrid.row]) then
    begin
      //if mainform.Label_onair.Caption='ON AIR' then mainform.btn_pause.OnClick(self);
      if IsMpegFile(playlistgrid.Cells[5,playlistgrid.row]) then
      begin
        audiofile.FileName :=playlistgrid.Cells[5,playlistgrid.row];
        audiofile.FadeOutDuration:=2000;
        audiofile.FadeInDuration:=500;
        WaveOut.Input := audiofile;
        waveout.Stop;
        waveout.Started;
      end;
    end else
    begin
      if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
      if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
    end;
  end;
end;

procedure TMusicLibrary.btn_stopClick(Sender: TObject);
begin
  audiofile.FadeOut(audiofile.FadeOutDuration);
end;

procedure TMusicLibrary.searchgridClick(Sender: TObject);
begin
  if searchgrid.Cells[0,searchgrid.row]<>'' then
  begin
     title.Caption:=searchgrid.Cells[0,searchgrid.row];
     mainform.testertitle.Caption:=title.Caption;
     formtester.FName1.Caption:=searchgrid.Cells[5,searchgrid.row];
  end else
  begin
     title.Caption:='';
     mainform.testertitle.Caption:='';
     formtester.FName1.Caption:=''
  end;
end;

procedure TMusicLibrary.newsinsertClick(Sender: TObject);
begin
  if searchgrid.Visible=false then
  begin
     if insertid=1 then
        begin
          insert1:=playlistgrid.Cells[5,playlistgrid.Row];
          newscomposer.ins1.Caption:='Insert1';
        end;
     if insertid=2 then
        begin
          insert2:=playlistgrid.Cells[5,playlistgrid.Row];
          newscomposer.ins2.Caption:='Insert2';
        end;
     if insertid=3 then
        begin
          insert3:=playlistgrid.Cells[5,playlistgrid.Row];
          newscomposer.ins3.Caption:='Insert3';
        end;
  end else
  if searchgrid.Visible=true then
  begin
     if insertid=1 then
        begin
          insert1:=searchgrid.Cells[5,searchgrid.Row];
          newscomposer.ins1.Caption:='Insert1';
        end;
     if insertid=2 then
        begin
          insert2:=searchgrid.Cells[5,searchgrid.Row];
          newscomposer.ins2.Caption:='Insert2';
        end;
     if insertid=3 then
        begin
          insert3:=searchgrid.Cells[5,searchgrid.Row];
          newscomposer.ins3.Caption:='Insert3';
        end;
  end;
  close;
end;

procedure TMusicLibrary.MusicLibTreeClick(Sender: TObject);
var types:string;
begin
  if musiclibtree.Selected.Selected=true then
  if musiclibtree.Items.Count>0 then

  begin
  playlistgrid.ClearRows(1,playlistgrid.RowCount);
  playlistgrid.RowCount:=2;

  musiclibrary.searchgrid.ClearRows(1,playlistgrid.RowCount);
  musiclibrary.searchgrid.RowCount:=2;

  if label1.Caption='FILE EXPLORER'   then types:='OTHER';
  if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
  if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
  if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
  if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
  if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
  if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
  if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

  reload:=false;

  searchgrid.Visible:=false;
  searchgrid.Visible:=false;

  if musiclibtree.Selected.Selected=true then
  begin
      if musiclibtree.Items.Count>0 then
      begin
        if musiclibtree.Selected.Selected then
        if musiclibtree.Selected.AbsoluteIndex>=0 then
        begin
          treegrid.Row:=musiclibtree.Selected.AbsoluteIndex+1;
          mainform.db_song.First;
          while not  mainform.db_song.Eof do
          begin
            if ((mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
                (mainform.db_song.FieldByName('Type').AsString  =types ) and
                (mainform.db_song.FieldByName('Kategori').AsString=treegrid.Cells[0,treegrid.row])) then
            begin
              if playlistgrid.Cells[0,playlistgrid.RowCount-1]<>'' then playlistgrid.RowCount:=playlistgrid.RowCount+1;
                 playlistgrid.Cells[0,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Filename').AsString;
                 playlistgrid.Cells[1,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Artist').AsString;
                 playlistgrid.Cells[2,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Album').AsString;
                 playlistgrid.Cells[3,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Genre').AsString;
                 playlistgrid.Cells[4,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Year').AsString;
                 playlistgrid.Cells[5,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Path').AsString;
            end;
            mainform.db_song.Next;
          end;
        end;
      end;
  end;
  end;
end;

procedure TMusicLibrary.MusicLibTreeChange(Sender: TObject;
  Node: TTreeNode);
var types:string;
begin
  if musiclibtree.Selected.Selected=true then
  if musiclibtree.Items.Count>0 then

  begin
  playlistgrid.ClearRows(1,playlistgrid.RowCount);
  playlistgrid.RowCount:=2;

  musiclibrary.searchgrid.ClearRows(1,playlistgrid.RowCount);
  musiclibrary.searchgrid.RowCount:=2;

  if label1.Caption='FILE EXPLORER'   then types:='OTHER';
  if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
  if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
  if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
  if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
  if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
  if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
  if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

  reload:=false;

  searchgrid.Visible:=false;
  searchgrid.Visible:=false;

  if musiclibtree.Selected.Selected=true then
  begin
      if musiclibtree.Items.Count>0 then
      begin
        if musiclibtree.Selected.Selected then
        if musiclibtree.Selected.AbsoluteIndex>=0 then
        begin
          treegrid.Row:=musiclibtree.Selected.AbsoluteIndex+1;
          mainform.db_song.First;
          while not  mainform.db_song.Eof do
          begin
            if ((mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
                (mainform.db_song.FieldByName('Type').AsString  =types ) and
                (mainform.db_song.FieldByName('Kategori').AsString=treegrid.Cells[0,treegrid.row])) then
            begin
              if playlistgrid.Cells[0,playlistgrid.RowCount-1]<>'' then playlistgrid.RowCount:=playlistgrid.RowCount+1;
                 playlistgrid.Cells[0,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Filename').AsString;
                 playlistgrid.Cells[1,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Artist').AsString;
                 playlistgrid.Cells[2,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Album').AsString;
                 playlistgrid.Cells[3,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Genre').AsString;
                 playlistgrid.Cells[4,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Year').AsString;
                 playlistgrid.Cells[5,playlistgrid.RowCount-1]:=mainform.db_song.FieldByName('Path').AsString;
            end;
            mainform.db_song.Next;
          end;
        end;
        if playlistgrid.Cells[1,1]='' then MMBitmapButton3.OnClick(Self);
      end;
  end;
  end;
end;

procedure TMusicLibrary.btn_tempClick(Sender: TObject);
begin
  if TempPlaylist.Visible=False then
  begin
    TempPlaylist.Caption:='Hide Temp Playlist';
    TempPlaylist.Visible:=True;
  end else
  begin
    TempPlaylist.Caption:='Show Temp Playlist';
    TempPlaylist.Visible:=False;
  end;
end;

procedure TMusicLibrary.MMBitmapButton9Click(Sender: TObject);
begin
  tempgrid.ClearRows(1,tempgrid.RowCount);
  tempgrid.RowCount:=2;
end;

procedure TMusicLibrary.MMBitmapButton8Click(Sender: TObject);
begin
  if tempgrid.Cells[0,tempgrid.Row]<>'' then
  begin
    if tempgrid.RowCount>2 then tempgrid.RemoveRows(tempgrid.Row,1) else
                                tempgrid.ClearRows(1,1);
  end;
end;

procedure TMusicLibrary.MMBitmapButton5Click(Sender: TObject);
begin
     if tempgrid.Row < tempgrid.Rowcount-1 then
     begin
        tempgrid.SwapRows(tempgrid.Row,tempgrid.Row+1);
        tempgrid.Row := tempgrid.Row+1;
     end else
     begin
        tempgrid.SwapRows(tempgrid.Row,1);
        tempgrid.Row := 1;
     end;
end;

procedure TMusicLibrary.MMBitmapButton4Click(Sender: TObject);
begin
     if tempgrid.Row>1 then
     begin
        tempgrid.SwapRows(tempgrid.Row,tempgrid.Row-1);
        tempgrid.Row := tempgrid.Row-1;
     end else
     begin
        tempgrid.SwapRows(tempgrid.Row,tempgrid.Rowcount-1);
        tempgrid.Row := tempgrid.Rowcount-1;
     end;
end;

procedure TMusicLibrary.MMBitmapButton11Click(Sender: TObject);
var i:Integer;
    types:string;
begin
  if label1.Caption='FILE EXPLORER'   then types:='OTHER';
  if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
  if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
  if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
  if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
  if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
  if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

  if searchgrid.Visible=true then
  begin
    if searchgrid.Cells[0,searchgrid.Row]<>'' then
    begin
      if tempgrid.Cells[0,1]<>'' then tempgrid.RowCount:=tempgrid.RowCount+1;
      for i:=0 to searchgrid.colCount-1 do tempgrid.Cells[i,tempgrid.RowCount-1]:=searchgrid.Cells[i,searchgrid.Row];
      tempgrid.Cells[4,tempgrid.RowCount-1]:=types;
    end;
  end else
  begin
    if playlistgrid.Cells[0,playlistgrid.Row]<>'' then
    begin
      if tempgrid.Cells[0,1]<>'' then tempgrid.RowCount:=tempgrid.RowCount+1;
      for i:=0 to playlistgrid.colCount-1 do tempgrid.Cells[i,tempgrid.RowCount-1]:=playlistgrid.Cells[i,playlistgrid.Row];
      tempgrid.Cells[4,tempgrid.RowCount-1]:=types;
    end;
  end;
end;

procedure TMusicLibrary.MMBitmapButton6Click(Sender: TObject);
var insertindex:Integer;
begin
  if fileexists(MusicLibrary.tempgrid.Cells[5,MusicLibrary.tempgrid.Row]) then
  begin
   if MusicLibrary.tempgrid.Cells[5,MusicLibrary.tempgrid.Row]<>'' then
   with playlist do
   begin
    if Playlistgrid.Cells[1,1]<>'' then Playlistgrid.InsertRows(Playlistgrid.row+1,1);
    if Playlistgrid.Cells[1,1]=''  then insertindex:=1 else insertindex:=Playlistgrid.row+1;

       Playlistgrid.cells[1,insertindex]:=extractfilename(MusicLibrary.tempgrid.Cells[5,MusicLibrary.tempgrid.Row]);
       Playlistgrid.Cells[5,insertindex]:=MusicLibrary.tempgrid.Cells[5,MusicLibrary.tempgrid.Row];
       Playlistgrid.Cells[0,insertindex]:='WAITING';
       Playlistgrid.Cells[6,insertindex]:=MusicLibrary.tempgrid.Cells[4,MusicLibrary.tempgrid.Row];

       //Get time
       if musicLibrary.tempgrid.Cells[6,MusicLibrary.tempgrid.Row]<>'' then
       begin
          Playlistgrid.Cells[3,insertindex]:=MusicLibrary.tempgrid.Cells[6,MusicLibrary.tempgrid.Row];
          Playlistgrid.Cells[2,insertindex]:=MSecToTime(StrToInt(MusicLibrary.tempgrid.Cells[6,MusicLibrary.tempgrid.Row]))
       end else
       begin
          mpegfile.FileName:=MusicLibrary.tempgrid.Cells[5,MusicLibrary.tempgrid.Row];
          Playlistgrid.Cells[3,insertindex]:=inttostr  (mpegfile.Frames * mpegfile.TimePerFrame);
          Playlistgrid.Cells[2,insertindex]:=MSecToTime(mpegfile.Frames * mpegfile.TimePerFrame);
          mpegfile.FreeMpeg;
       end;

       cek_total;

       playlistindex:=mainform.getindex;
       mainform.settimeup(playlistindex);
       mainform.playlist_color;

       playlist.Playlistgrid.AutoSizeRows(false,0);
       playlist.Playlistgrid.SaveTofile(savedir+'setting\playlist.dat');
       Playlistgrid.row:=insertindex;
   end;
  end else
  begin
      if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
      if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
  end;
end;

procedure TMusicLibrary.MMBitmapButton7Click(Sender: TObject);
begin
  MMBitmapButton6.OnClick(Self);
  mainform.btn_next.OnClick(Self);
end;

procedure TMusicLibrary.MMBitmapButton10Click(Sender: TObject);
var i:integer;
begin
  Playlist.ClearPlaylist1.OnClick(Self);
  for i:=1 to tempgrid.RowCount-1 do
  begin
    if tempgrid.Cells[0,i]<>'' then
    begin
      tempgrid.Row:=i;
      MMBitmapButton6.OnClick(Self);
    end;
  end;
end;

procedure TMusicLibrary.tempgridClick(Sender: TObject);
begin
  if tempgrid.Cells[0,tempgrid.row]<>'' then
  begin
     title.Caption:=tempgrid.Cells[0,tempgrid.row];
     mainform.testertitle.Caption:=title.Caption;
     formtester.FName1.Caption:=tempgrid.Cells[5,tempgrid.row];
  end else
  begin
     title.Caption:='';
     mainform.testertitle.Caption:='';
     formtester.FName1.Caption:=''
  end;
end;


procedure TMusicLibrary.MMBitmapButton14Click(Sender: TObject);
begin
  mainform.MMBitmapButton4.OnClick(Self);
end;

procedure TMusicLibrary.MMBitmapButton12Click(Sender: TObject);
begin
  mainform.MMBitmapButton3.OnClick(self);
end;

procedure TMusicLibrary.MMBitmapButton13Click(Sender: TObject);
begin
  mainform.MMBitmapButton5.OnClick(Self);
end;

end.
